function live_chat_on(page) {
  switch(page) {
    case 'ppap':
      $('#stream_cell').removeClass("col-sm-9").addClass("col-sm-11");
      $('#live_cell').removeClass("col-sm-3").addClass("col-sm-1");
      $('#live_visible').text("Live");
      $('#live_visible').css('width', '58px');
      $('#loadtime').show();
      break
    case 'stream':
      $('#stream_cell').removeClass("col-sm-9").addClass("col-sm-11");
      $('#live_cell').removeClass("col-sm-3").addClass("col-sm-1");
      $('#live_visible').text("Live");
      $('#live_visible').css('width', '58px');
      $('#stream_help').show();
      $('#table_size').show();
      $('#font_size').show();
      $('#free_mode').show();
      $('#table_size_label').show();
      $('#font_size_label').show();
      $('#free_mode_label').show();
      break
    default:
      break
  }
  false
}

function live_chat_off(page) {
  switch(page) {
    case 'ppap':
      $('#stream_cell').removeClass("col-sm-11").addClass("col-sm-9");
      $('#live_cell').removeClass("col-sm-1").addClass("col-sm-3");
      $('#live_visible').text("Live Chat");
      $('#live_visible').css('width', '');
      $('#loadtime').hide();
      break
    case 'stream':
      $('#stream_cell').removeClass("col-sm-11").addClass("col-sm-9");
      $('#live_cell').removeClass("col-sm-1").addClass("col-sm-3");
      $('#live_visible').text("Live Chat");
      $('#live_visible').css('width', '');
      $('#stream_help').hide();
      $('#table_size').hide();
      $('#font_size').hide();
      $('#free_mode').hide();
      $('#table_size_label').hide();
      $('#font_size_label').hide();
      $('#free_mode_label').hide();
      break
    default:
      break
  }
  false
}

function chat_history() {
  url = '/api/v1/mix_history';

  $.ajax({
    url: url,
    type: "GET",
    timeout: 20000,
    success: function(data) {
      template  = '<tr><td><div class="text-nowrap fixed">NAME</div></td>';
      template += '<td><div class="small">BODY</div></td></tr>';

      $.each(data, function(index, value){
        switch(value.stat) {
          case 'ch':
            template2 = template.replace(/NAME/, value.name);
            template2 = template2.replace(/BODY/, value.body);

            $("#stream_chat_table tbody").append(template2);
            break;
          case 'wh':
            s = ""    
            if (value.name == 'all') {
              s = "全鯖"    
            } else {
              s = value.name.toUpperCase() + "鯖";
            };

            cd = "";
            switch(value.name) {
              case 'all':
                cd = '<span class="badge badge-info">';
                break
              case 's':
                cd = '<span class="badge badge-danger">';
                break
              case 'b':
                cd = '<span class="badge badge-primary">';
                break
              case 'v':
                cd = '<span class="badge badge-warning">';
                break
              case 'g':
                cd = '<span class="badge badge-secondary">';
                break
              default:
                break;
            };

            cds = cd + s + '</span>'
            template2 = template.replace(/NAME/, cds);
            template2 = template2.replace(/BODY/, value.body);

            $("#stream_chat_table tbody").append(template2);
            break;
        };
      });
    },
      error: function() {
        $('#stream_chat_text').text('');
    }
  });
};
