function init() {
  var ws = null;
  open();
}

function open() {
  var proto  = location.protocol === 'https:' ? 'wss' : 'ws'
  var ws     = new WebSocket(proto + '://' + window.location.host + window.location.pathname);

  ws.onopen  = function() {
  };

  ws.onclose = function() {
    ws = null;
    setTimeout(open(), 500);
  };

  ws.onmessage = function(m) { 
    template = 'BODY';
    show_json(m.data, template);
  };
};

function show_json(msg, template){
  var j = $.parseJSON(msg);

  template  = '<tr><td>BODY</td></tr>';
  template  = template.replace(/BODY/, j.body);

  $("#stream_table tbody").prepend(template);
  $("#stream_table tbody tr:last").hide().fadeOut(2000).remove();
  $("#stream_table tbody tr:first").hide().fadeIn(2000);
  $("#power").text(j.id.replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,")).hide().fadeIn(500);
};

function close() {
  ws = null;
};

function log_history() {
  url = '/api/v1/top_shout';

  $.ajax({
    url: url,
    type: "GET",
    timeout: 20000,
    success: function(data) {
      template = "<tr><td>BODY</td></tr>";
      $.each(data, function(index, value){
        template2 = template.replace("BODY", value);
        $("#stream_table tbody").append(template2);
      });
    },
      error: function() {
        $('#stream_text').text('');
    }
  });
};

window.onload = function(){
  log_history();
  init();
};
