# -*- encoding: utf-8 -*-

# active_support 5.0.2 and Ruby2.4.1 bugs for date241
require_relative 'lib/date241'
require_relative 'lib/extra'
require_relative 'lib/api'
require_relative 'lib/text2voice'
require_relative 'lib/version'

# ip_to_earth
#require 'ip_to_earth'

require 'dalli'
require 'sinatra/base'
require 'sinatra/cookies'
require 'sinatra/activerecord'
require 'json'
require 'kconv'
require "nkf"
require 'cgi'
require 'date'
require 'digest/md5'
require 'parsedate'
require 'dotenv'
require 'zlib'
require 'base64'

require 'net/http'
require 'addressable/uri'
require 'securerandom'

require './models/papamira.rb'
Dotenv.load

$cache = Dalli::Client.new ENV['MEMCACHEDCLOUD_SERVERS'], {:username => ENV['MEMCACHEDCLOUD_USERNAME'], :password => ENV['MEMCACHEDCLOUD_PASSWORD']}

ENV['PPAP_S_API_KEY'] = SecureRandom.uuid if ENV['PPAP_S_API_KEY'].nil?
ENV['PPAP_B_API_KEY'] = SecureRandom.uuid if ENV['PPAP_B_API_KEY'].nil?
ENV['PPAP_V_API_KEY'] = SecureRandom.uuid if ENV['PPAP_V_API_KEY'].nil?
ENV['PPAP_G_API_KEY'] = SecureRandom.uuid if ENV['PPAP_G_API_KEY'].nil?
ENV['PPAP_VOICE_API_KEY'] = SecureRandom.uuid if ENV['PPAP_VOICE_API_KEY'].nil?

if File.exist?("secret/api-key.json")
  API_KEY = JSON.parse(File.open("secret/api-key.json").read)
else
  API_KEY = {
    's' => ENV['PPAP_S_API_KEY'],
    'b' => ENV['PPAP_B_API_KEY'],
    'v' => ENV['PPAP_V_API_KEY'],
    'g' => ENV['PPAP_G_API_KEY'],
    'voice' => ENV['PPAP_VOICE_API_KEY'],
  }
end

puts "API-KEY"
API_KEY.each do |server, key|
  puts "#{server}: #{key}"
end

$web_clients = []

$spool_data = {
  'v' => [],
  'b' => [],
  's' => [],
  'g' => [],
}

$lock = {
  'all' => false,
  'v' => false,
  'b' => false, 
  's' => false,
  'g' => false,
}

$search_stack = {
  'v' => 0,
  'b' => 0, 
  's' => 0,
  'g' => 0,
  'all' => 0,
}

$search_max = {
  'v' => 3,
  'b' => 3, 
  's' => 3,
  'g' => 3,
  'all' => 3,
}

$store_audio = []
$form_us = ""
$form_us_time = Time.now

SERVERS = ['s', 'b', 'v', 'g']

module Papamira
  class App < Sinatra::Base
    @@papi = Papamira_API.new

    helpers Sinatra::Cookies
    helpers do
      def lock(server="")
        if server.empty?
          return $lock
        else
          return $lock[server]
        end
      end

      def set_lock(server="", flg=true)
        if server.empty?
          false
        else
          $lock[server] = flg
          true
        end
      end

      def spool(server="")
        if server.empty?
          return $spool_data
        else
          return $spool_data[server]
        end
      end

      def search_word_save(server, word)
        word = URI.unescape(word).toutf8
        p "Server: #{server}"
        p "SearchWord: " + word

        if PapamiraSearchWord.where(server: server).count != 0
          pDB = PapamiraSearchWord.find_by(server: server)
          body_in = JSON.parse(pDB[:data])

          body_flg = true
          body_in.each do |body|
            if body['body'] == word
              body['count'] += 1
              body_flg = false
              break
            end
          end

          if body_flg
            body_in.push(
              {'body' => word, 
               'count' => 1,
              }
            )
          end

          pDB.update(
            server: server,
            data: JSON.generate(body_in),
          )
          pDB.save
        else
          search_data = []
          search_data.push(
            {'body' => word, 
             'count' => 1,
            }
          )
          pDB = PapamiraSearchWord.new(
            :server => server,
            :data => JSON.generate(search_data),
          )
          pDB.save
        end
        ""
      end

      def p2d_text2voice(path)
        $store_audio.push(path)
        if $store_audio.size > 30
          if File.exist?('/tmp/' + $store_audio.first)
            File.delete('/tmp/' + $store_audio.first)
          end
          $store_audio.shift
        end
      end

      def make_text2voice_raw(body)
        ext = 'mp3'
        path = '/tmp/'
        md5_name = Digest::MD5.hexdigest(body).to_s

        if File.exist?(path + md5_name + '.' + ext)
          return (path + md5_name + '.' + ext)
        else
          voice = TextToVoice.new(API_KEY['voice'])
          voice.speak(body)
            .speaker("hikari")
            .speed("100")
            .format(ext)
            .emotion(emotion: :happiness, level: :high)

          full_path = path + md5_name + ".#{ext}"
          voice.save_as(full_path)
          p2d_text2voice(full_path)
          return full_path
        end
      end

      def make_text2voice_public(body)
        full_path = self.make_text2voice_raw(body)
        if File.exist?(full_path)
          public_path = '/store/'
          return full_path.sub(/^\/tmp\//, public_path).sub(/\.mp3$/, "")
        else
          return ""
        end
      end

      def push_defalut(server, params)
        marge_flg = false
        if params['key'].to_s == API_KEY[server]
          data_page = 0
          days = Date.parse(params['date']).to_s
          if PapamiraWorld.where(server: server, tags: 'day', days: days).count == 0
            shout_data = JSON.generate([params])
            pDB = PapamiraWorld.new(
              :server => server,
              :tags => 'day',
              :days => days,
              :body => shout_data,
              :date => DateTime.now
            )
            pDB.save
          else
            pDB = PapamiraWorld.find_by(server: server, tags: 'day', days: days)
            shout_data_in = pDB[:body]
            data = JSON.parse(shout_data_in)
            data.push(params)
            data_page = (data.size - 1).to_s
            shout_data_out = JSON.generate(data)

            pDB.update(
              server: server,
              tags: 'day',
              days: days,
              body: shout_data_out,
              date: DateTime.now
            )
            pDB.save
          end

          ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
          GC.start

          if lock(server) == false
            $cache.delete(server + "_now")
            $cache.delete(server + "_now_m")
            $cache.delete("shout_" + server)
            $cache.delete("shout_days_" + server + "_1")
            $cache.delete("shout_days_" + server + "_2")
            $cache.delete("shout_days_" + server + "_3")
            $cache.delete("shout_days_" + server + "_7")
            $cache.delete("shout_days_" + server + "_14")
            $cache.delete("all_shout")

            params['search_name'] = NKF.nkf("-Xwm0Z1", (params['name']).upcase)
            params['search_body'] = NKF.nkf("-Xwm0Z1", (params['body']).upcase)
            params['page'] = data_page

            web_peoples = $web_clients.size.to_s
            $web_clients.each { |client| 
              s = client.env['REQUEST_URI'].scan(/^\/(s|b|v|g|all)\/(stream|ppap)$/).flatten[0]
              if API_KEY[s] == params['key'] or client.env['REQUEST_URI'] == '/' or s == 'all'
                params2 = params.dup
                speak_body = ""

                if s == 'all'
                  rserver = ''
                  API_KEY.each do |server_name, api_key|
                    if api_key == params2['key']
                      rserver = server_name
                    end
                  end
                  params2['server'] = rserver
                end

                if client.env['REQUEST_URI'] == '/'
                  params2['page'] = ''
                  params2['stat'] = ''
                  params2['name'] = ''
                  params2['date'] = ''
                  params2['search_name'] = ''
                  params2['search_body'] = ''
                  params2.delete('page')
                  params2.delete('stat')
                  params2.delete('name')
                  params2.delete('date')
                  params2.delete('search_name')
                  params2.delete('search_body')
                else
                  begin
                    if params['body'].size != 0
                      case s
                      when 'all'
                        speak_body = "#{rserver}鯖 " + params['body']
                        params2['web_people'] = web_peoples
                      when 's', 'b', 'v', 'g'
                        speak_body = params['body']
                        params2['web_people'] = web_peoples
                      else
                        speak_body = params['body']
                      end

                      store_path = make_text2voice_public(speak_body)
                      if store_path.empty?
                        params2['store_audio'] = ''
                        params2.delete('store_audio')
                      else
                        params2['store_audio'] = store_path
                      end
                    else
                      case s
                      when 'all', 's', 'b', 'v', 'g'
                        params2['web_people'] = web_peoples
                      end
                    end
                  rescue
                    case s
                    when 'all', 's', 'b', 'v', 'g'
                      params2['web_people'] = web_peoples
                    end
                    params2['store_audio'] = ''
                    params2.delete('store_audio')
                  end
                end

                params2['key'] = ''
                params2.delete('key')
                client.send(JSON.generate(params2))
                #p [:send, client.object_id]
              end
            }

            params['page'] = ''
            params['search_name'] = ''
            params['search_body'] = ''
            params.delete('page')
            params.delete('search_name')
            params.delete('search_body')

            if PapamiraWorld.where(server: 'all', tags: 'now').count != 0
              pDB = PapamiraWorld.find_by(server: 'all', tags: 'now')
              pDB.update(
                server: 'all',
                tags: 'now',
                date: DateTime.now,
                body: JSON.generate(params)
              )
            else
              pDB = PapamiraWorld.new(
                :server => 'all',
                :tags => 'now',
                :date => DateTime.now,
                :body => JSON.generate(params)
              )
              pDB.save
            end

            if PapamiraWorld.where(server: server, tags: 'now').count != 0
              pDB = PapamiraWorld.find_by(server: server, tags: 'now')
              pDB.update(
                date: params['date'],
                body: JSON.generate(params)
              )
            else
              pDB = PapamiraWorld.new(
                :server => server,
                :tags => 'now',
                :date => params['date'],
                :body => JSON.generate(params)
              )
              pDB.save
            end

            ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
            GC.start

          else
            spool(server).push( { "render" => params } )
          end

          marge_flg = true
        end
        return marge_flg
      end

      def push_days_defalut(server, params)
        marge_flg = false

        uniq_days = params['days']
        key = params['key']
        hdata = params['data']

        day_base_hdata = []
        hdata.each do |j|
          stat = j['stat']
          if key == API_KEY[server]
            if /^(wt|sh)$/ =~ stat
              j.delete('key')
              day_base_hdata.push(j)
            end
          end
        end

        PapamiraWorld.where(server: server, tags: 'day', days: uniq_days).delete_all
        shout_data = JSON.generate(day_base_hdata)
        pDB = PapamiraWorld.new(
          :server => server,
          :tags => 'day',
          :days => uniq_days,
          :body => shout_data,
          :date => DateTime.now
        )
        pDB.save
        marge_flg = true

        day_base_hdata.clear
        hdata.clear
        ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
        GC.start

        return marge_flg
      end

      def push_all_defalut(server, params)
        marge_flg = false

        key = params['key']
        hdata = params['data']

        day_base_hdata = {}
        hdata.each do |j|
          stat = j['stat']
          if key == API_KEY[server]
            if /^(wt|sh)$/ =~ stat
              j.delete('key')
              days = Date.parse(j['date']).to_s
              if day_base_hdata[days].nil?
                day_base_hdata[days] = [j]
              else
                day_base_hdata[days].push(j)
              end
            end
          end
        end

        PapamiraWorld.where(server: server, tags: 'day').delete_all

        day_base_hdata.each do |days, data|
          spool(server).each do |h|
            data.unshift(h['render'])
          end
          spool(server).clear

          shout_data = JSON.generate(data)
          pDB = PapamiraWorld.new(
            :server => server,
            :tags => 'day',
            :days => days,
            :body => shout_data,
            :date => DateTime.now
          )
          pDB.save
        end

        day_base_hdata.clear
        hdata.clear
        ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
        GC.start

        return marge_flg
      end

      def server_active 
        JSON.parse(@@papi.server_active)
      end

      def server_active_render
        key = 'server_active_render'
        sa = {}

        if $cache.fetch(key).nil?
          self.server_active.each do |s, stat|
            case stat
            when "up"
              sa[s] = "<b class=\"badge badge-primary\">#{stat}</b>"
            when "down"
              sa[s] = "<b class=\"badge badge-warning\">#{stat}</b>"
            else
              case stat
              when 0
                sa[s] = "<b class=\"badge badge-danger\">#{stat}鯖UP</b>"
              when 1
                sa[s] = "<b class=\"badge badge-warning\">#{stat}鯖UP</b>"
              when 2
                sa[s] = "<b class=\"badge badge-info\">#{stat}鯖UP</b>"
              when 3
                sa[s] = "<b class=\"badge badge-primary\">#{stat}鯖UP</b>"
              when 4
                sa[s] = "<b class=\"badge badge-primary\">#{stat}鯖UP</b>"
              else
                sa[s] = "<b class=\"badge badge-danger\">不明</b>"
              end
            end
          end
          $cache.set(key, sa, 300)
        else
          sa = $cache.get(key)
        end
        return sa
      end

      def chat_check(name, text)
        flg = false
        if text.size <= 40 and text.size != 0
          if name.size <= 20 and name.size != 0
            flg = true
          end
        end
        flg
      end

      def chat_people
        return $web_clients.size + 1
      end

      def chat_get(key="chat_data")
        if $cache.fetch(key).nil?
          ref = ""
          PapamiraChat.all.reverse_each do |data|
            ref << '<span class="badge badge-dark">'+data[:name]+'</span>: <span class="small">'+data[:body] + "</span><br>"
          end
          $cache.set(key, ref, 3600)
        else
          ref = $cache.get(key)
        end
        ref
      end

      def form_output(params)
        puts "-----------------------------------------------"
        puts "お問い合わせ[Contact Us]"
        puts "-----------------------------------------------"
        puts "Name: " + params[:f_name].toutf8
        puts "Mail: " + params[:f_mail].toutf8
        puts "Subject: " + params[:f_subject].toutf8
        puts "-----------------------------------------------"
        puts "Text: " + params[:f_text].toutf8
        puts "-----------------------------------------------"
        true
      end
    end

    before do
      # HTTPS redirect
      if request.env['REMOTE_ADDR'] != '127.0.0.1' && request.scheme != 'https'
        if /^192.168.(0|1)./ !~ request.env['REMOTE_ADDR']
          if request.env['REQUEST_PATH'] != '/proxy_kr'
            redirect "https://#{request.env['HTTP_HOST']}"
          end
        end
      end
    end

    after do
      ActiveRecord::Base.connection.close
    end

    post '/push2', provides: :json do
      marge_flg = false
      params = JSON.parse(request.body.read)
      stat = params['stat']

      if /^(wt|sh)$/ =~ stat
        case params['key'].to_s
        when API_KEY['v']
          marge_flg = push_defalut('v', params)
        when API_KEY['b']
          marge_flg = push_defalut('b', params)
        when API_KEY['s']
          marge_flg = push_defalut('s', params)
        when API_KEY['g']
          marge_flg = push_defalut('g', params)
        end
      end
      marge_flg.to_s
    end
 
    post '/push_days', provides: :json do
      marge_flg = false
      params = JSON.parse(request.body.read)
      case params['key'].to_s
      when API_KEY['v']
        marge_flg = push_days_defalut('v', params)
      when API_KEY['b']
        marge_flg = push_days_defalut('b', params)
      when API_KEY['s']
        marge_flg = push_days_defalut('s', params)
      when API_KEY['g']
        marge_flg = push_days_defalut('g', params)
      end
      marge_flg.to_s
    end

    post '/push_all', provides: :json do
      #marge_flg = false
      #params = JSON.parse(request.body.read)
      #case params['key'].to_s
      #when API_KEY['v']
      #  marge_flg = push_all_defalut('v', params)
      #when API_KEY['b']
      #  marge_flg = push_all_defalut('b', params)
      #when API_KEY['s']
      #  marge_flg = push_all_defalut('s', params)
      #when API_KEY['g']
      #  marge_flg = push_all_defalut('g', params)
      #end
      #marge_flg.to_s
    end

    post %r{/(v|b|s|g)/lock}, provides: :json do |server|
      if params['key'].to_s == API_KEY[server]
        set_lock(server, true)
      end
    end

    post %r{/(v|b|s|g)/unlock}, provides: :json do |server|
      if params['key'].to_s == API_KEY[server]
        set_lock(server, false)
      end
    end

    get '/' do
      @s = self.server_active_render()
      @body = JSON.parse(@@papi.now_shout)
      @server_hp = JSON.parse(@@papi.server_hitpoint)
      @server_version = Papamira_Status.Version
      erb :top
    end

    get '/keepalive' do
      ""
    end

    get '/feature' do
      markdown :fake
    end

    get %r!/(v|b|s|g)/(select_shout|ss)/(\d{4})/(\d{2})/(\d{2})/(([0-9]|-|,)+)! do |server, url, y, m, d, pages, page|
      params = {}
      params[:server] = server
      params[:day] = [y, m, d, pages].join("-")
      jdata = JSON.parse(@@papi.select_shout(params))
      @body = ""
      if not jdata.empty?
        jdata.each do |data|
          @body << data['body'] + "<br>\n"
        end
      else
        @body = ""
      end
      erb :select_shout, :layout => :plane
    end

    get %r{/(v|b|s|g)/ppap} do |server|
      @title_server = server.to_s.upcase
      @chat_people = chat_people()
      @chat_body = chat_get()
      erb :ppap
    end

    get %r{/(v|b|s|g)/stream} do |server|
      @title_server = server.to_s.upcase
      @chat_people = chat_people()
      @chat_body = chat_get()
      erb :stream
    end

    get "/all/stream" do
      @chat_people = chat_people()
      @chat_body = chat_get()
      erb :all_stream
    end

    get '/info' do
      erb :info_all
    end

    get '/info_wdays' do
      erb :info_wdays
    end

    get '/info_calendar' do
      erb :info_calendar
    end

    get %r{/(v|b|s|g)/info} do |server|
      erb :info
    end

    get '/chat_send' do
      data = {}
      data['name'] = CGI.escapeHTML(params[:chat_name].to_s)
      data['text'] = CGI.escapeHTML(params[:chat_text].to_s)

      if chat_check(data['name'], data['text'])
        data['host'] = request.env['REMOTE_ADDR'].to_s
        data['date'] = Time.now.to_s
        lpDB = PapamiraChat.last

        if lpDB.nil?
          pDB = PapamiraChat.new(
            :name => data['name'],
            :body => data['text'],
            :host => data['host'],
            :time => data['date'],
          )
          pDB.save

          params2 = {}
          params2['mode'] = 'chat'
          params2['name'] = data['name']
          params2['body'] = data['text']
          jparams = JSON.generate(params2)
          $web_clients.each { |client|
            client.send(jparams)
          }

          $cache.delete("chat_data")
          p [:chat, data['date'], data['text']]
        else
          if lpDB.body != data['text']
            pDB = PapamiraChat.new(
              :name => data['name'],
              :body => data['text'],
              :host => data['host'],
              :time => data['date'],
            )
            pDB.save
            if PapamiraChat.count > 100
              fpDB = PapamiraChat.first
              fpDB.delete
            end

            params2 = {}
            params2['mode'] = 'chat'
            params2['name'] = data['name']
            params2['body'] = data['text']
            jparams = JSON.generate(params2)
            $web_clients.each { |client|
              client.send(jparams)
            }

            $cache.delete("chat_data")
            p [:chat, data['date'], data['text']]
          end
        end
      end
      ""
    end

    get '/ranking' do
      erb :ranking
    end

    get '/words' do
      erb :words
    end

    get %r{/store/([\w]+)} do |voice|
      send_file '/tmp/' + voice + '.mp3', :filename => voice
    end

    get '/form' do
      erb :form
    end

    post '/form' do
      @user_name  = params[:f_name].toutf8
      @user_email = params[:f_mail].toutf8
      @user_subject = params[:f_subject].toutf8
      @user_text = params[:f_text].toutf8
      erb :form
    end

    post '/form_confirm' do
      @user_name  = params[:f_name].toutf8
      @user_email = params[:f_mail].toutf8
      @user_subject = params[:f_subject].toutf8
      @user_text = params[:f_text].toutf8
      @user_error = ""

      if !@user_name.empty? and !@user_email.empty? and !@user_text.empty?
        @user_error = "時間を空けてから投稿してください。<br>連続した投稿は出来ません。"
        if $form_us.empty?
          erb :form_confirm
        else
          if request.env['HTTP_X_FORWARDED_FOR'].to_s.empty?
            if $form_us != request.env['REMOTE_ADDR'].to_s
              erb :form_confirm
            else
              if (Time.now - $form_us_time) >= 300
                erb :form_confirm
              else
                erb :form_error
              end
            end
          else
            if $form_us != request.env['HTTP_X_FORWARDED_FOR'].to_s.split(/,/).last
              erb :form_confirm
            else
              if (Time.now - $form_us_time) >= 300
                erb :form_confirm
              else
                erb :form_error
              end
            end
          end
        end
      else
        @user_error = "必須項目に未記入があります"
        erb :form_error
      end
    end

    post '/form_post' do
      @user_name  = params[:f_name].toutf8
      @user_email = params[:f_mail].toutf8
      @user_text = params[:f_text].toutf8
      @user_error = ""

      if !@user_name.empty? and !@user_email.empty? and !@user_text.empty?
        @user_error = "時間を空けてから投稿してください。<br>連続した投稿は出来ません。"
        if $form_us.empty?
          form_output(params)
          if request.env['HTTP_X_FORWARDED_FOR'].to_s.empty?
            $form_us = request.env['REMOTE_ADDR'].to_s
          else
            $form_us = request.env['HTTP_X_FORWARDED_FOR'].to_s.split(/,/).last
          end
          $form_us_time = Time.now
          erb :form_post
        else
          if request.env['HTTP_X_FORWARDED_FOR'].to_s.empty?
            if $form_us != request.env['REMOTE_ADDR'].to_s
              form_output(params)
              $form_us = request.env['REMOTE_ADDR'].to_s
              $form_us_time = Time.now
              erb :form_post
            else
              if (Time.now - $form_us_time) >= 300
                form_output(params)
                $form_us = request.env['REMOTE_ADDR'].to_s
                $form_us_time = Time.now
                erb :form_post
              else
                erb :form_error
              end
            end
          else
            if $form_us != request.env['HTTP_X_FORWARDED_FOR'].to_s.split(/,/).last
              form_output(params)
              $form_us = request.env['HTTP_X_FORWARDED_FOR'].to_s.split(/,/).last
              $form_us_time = Time.now
              erb :form_post
            else
              if (Time.now - $form_us_time) >= 300
                form_output(params)
                $form_us = request.env['HTTP_X_FORWARDED_FOR'].to_s.split(/,/).last
                $form_us_time = Time.now
                erb :form_post
              else
                erb :form_error
              end
            end
          end
        end
      else
        @user_error = "必須項目に未記入があります"
        erb :form_error
      end
    end

    get '/update' do
      erb :update
    end

    get '/testing' do
      erb :testing
    end

    get '/game1' do
      erb :game
    end

    get '/help' do
      erb :help
    end

    get '/dev' do
      @server_version = Papamira_Status.Version
      if File.exist?("README.md")
        @readme = File.open("README.md").read.gsub(/\n/, "<br>\n")
      else
        @readme = ""
      end
      erb :dev
    end

    get '/source' do
      erb :source
    end

    get '/download/lib' do
      send_file 'middle/shout.rb', :filename => 'papamira.rb'
    end

    get '/download/web' do
      send_file 'middle/web.zip', :filename => 'papamira-web.zip'
    end

    get %r!/(api|api/)! do
      erb :api
    end

    get '/api/v1/random_shout', provides: :json do
      @@papi.random_shout
    end

    get '/api/v1/shout', provides: :json do
      @@papi.shout(params)
    end

    get '/api/v1/shout_days', provides: :json do
      @@papi.shout_days(params)
    end

    get '/api/v1/all_shout', provides: :json do
      @@papi.all_shout
    end

    get '/api/v1/select_day', provides: :json do
      @@papi.select_day(params)
    end

    get '/api/v1/select_shout', provides: :json do
      @@papi.select_shout(params)
    end

    get '/api/v1/autocomplete', provides: :json do
      @@papi.autocomplete(params)
    end

    get '/api/v1/user_search_word', provides: :json do
      @@papi.user_search_word(params)
    end

    get '/api/v1/search_shout', provides: :json do
      @@papi.search_shout(params)
    end

    get '/api/v1/search_tags', provides: :json do
      @@papi.search_tags(params)
    end

    get '/api/v1/search_name', provides: :json do
      @@papi.search_name(params)
    end

    get '/api/v1/1day_shout', provides: :json do
      @@papi._1day_shout(params)
    end

    get '/api/v1/info_server', provides: :json do
      @@papi.graph_server(params)
    end

    get '/api/v1/info_day', provides: :json do
      @@papi.graph_days(params)
    end

    get '/api/v1/info_wday', provides: :json do
      @@papi.graph_wdays(params)
    end

    get '/api/v1/info_calendar', provides: :json do
      @@papi.graph_select_day(params)
    end

    get '/api/v1/ranking', provides: :json do
      @@papi.ranking()
    end

    get '/api/v1/words', provides: :json do
      @@papi.words()
    end

    get '/api/v1/server_active', provides: :json do
      @@papi.server_active()
    end

    get '/api/v1/web_connect_int', provides: :json do
      @@papi.all_web_connect
    end

    get '/api/v1/web_connect', provides: :json do
      @@papi.web_connect(params)
    end

    get '/api/v1/web_connects', provides: :json do
      @@papi.web_connects
    end

    get '/api/v1/server_alive', provides: :json do
      @@papi.server_alive(params)
    end

    get '/api/v1/server_hitpoint', provides: :json do
      @@papi.server_hitpoint
    end

    get '/api/v1/voice_dic', provides: :json do
      @@papi.voice_dic
    end

    get '/api/v1/ppap_shout', provides: :json do
      ppap = JSON.parse(File.open('data/ppap.dic').read)
      JSON.generate(ppap[rand(0..ppap.size)])
    end

    get '/api/v1/version', provides: :json do
      JSON.generate(Papamira_Status.Version)
    end

    error 404 do
      puts 'not found: ' + env["REQUEST_PATH"]
      return '404'
    end
  end
end

