class Papamira_API
  SERVER_HP = 10000
  require 'json'
  require 'nkf'

  def lock(server="")
    if server.empty?
      return $lock
    else
      return $lock[server]
    end
  end

  def render_popup
    template_body = "update.."
    return template_body
  end

  def render_wait_search
    template_body = "お腹いっぱいです しばらく待って検索してね."
    return template_body
  end

  def num_search(word)
    res = ""
    word.split(/\s/).each do |t|
      if /(\S*)\[(\d+\.*\d*)-(\d+\.*\d*),*(\d*)\](\S*)/ =~ t
        w,x,y,r,z = t.scan(/(\S*)\[(\d+\.*\d*)-(\d+\.*\d*),*(\d*)\](\S*)/).flatten
        if !x.nil? and !y.nil?
          p "SearchParameter: " + t
          if x >= y
            a = y.to_f
            b = x.to_f
          else
            a = x.to_f
            b = y.to_f
          end
          z = "[^\\d]" if z.nil? or z.empty?
          w = "[^\\d]" if w.nil? or w.empty?

          if /(\d+\.\d+)/ =~ b.to_s.sub(/\.0+$/, "")
            if r.nil? or r.empty?
              r = 0.1
            else
              r = (r.to_f / 10) if r.to_f >= 1
            end
            r = r.to_f
          else
            if r.nil? or r.empty?
              r = 1
            else
              r = 1 if r.to_f <= 0
            end
            a = a.to_i
            b = b.to_i
            r = r.to_i
          end

          tint = (b.to_f - a.to_f).to_i / r.to_i
          break if tint > 1000

          case (b.to_f - a.to_f).to_f
          when 0
            c = "#{w.to_s + a.to_s + z.to_s}"
          when 1
            c = "#{w.to_s + a.to_s + z.to_s}|#{w.to_s + b.to_s + z.to_s}"
          else
            if r >= 1
              c = w.to_s + a.to_s + z.to_s + "|"
              ((b - a) / r).times do |i|
                c << w.to_s + (a + ((i+1) * r)).to_s + z.to_s + "|"
              end
            else
              c = w.to_s + a.to_s.sub(/\./, "\\.") + z.to_s + "|"
              ((((b.to_f - a.to_f).to_f * 10).to_f / (r.to_f * 10)).to_i).to_i.times do |i|
                if i == 0
                  i = 1 * r.to_f
                else
                  i = (1 + i.to_f) * r.to_f 
                end
                c << w.to_s + ((a + i).round(1)).to_s.sub(/\./, "\\.") + z.to_s + "|"
              end
            end
            c = c.sub(/\|$/, "")
          end
          res << "(?=.*(#{c}))" 
        end
      end
    end
    return res
  end

  def num_search_delete(word)
    return word.dup.gsub(/(\S*)\[(\d+\.*\d*)-(\d+\.*\d*),*(\d*)\](\S*)/, "")
  end

  def search_word_save(server, word)
    word = URI.unescape(word).toutf8
    p "Server: #{server}"
    p "SearchWord: " + word

    wordp = word.gsub(/((\\ +)|(　+))+/, " ").split(/\s+/)
    wordp.each do |word|
      if PapamiraSearchWord.where(server: server).count != 0
        pDB = PapamiraSearchWord.find_by(server: server)
        body_in = JSON.parse(pDB[:data])

        body_flg = true
        body_in.each do |body|
          if body['body'] == word
            body['count'] += 1
            body_flg = false
            break
          end
        end

        if body_flg
          body_in.push(
            {'body' => word, 
             'count' => 1,
            }
          )
        end

        pDB.update(
          server: server,
          data: JSON.generate(body_in),
        )
        pDB.save
      else
        search_data = []
        search_data.push(
          {'body' => word, 
           'count' => 1,
          }
        )
        pDB = PapamiraSearchWord.new(
          :server => server,
          :data => JSON.generate(search_data),
        )
        pDB.save
      end
    end
    ""
  end

  def server_active 
    key = 'top_server_active'
    s = {}
    all = 0
    if $cache.fetch(key).nil?
      SERVERS.each do |server|
        s[server] = "down"
        if PapamiraWorld.where(server: server, tags: 'now').count != 0
          pDB = PapamiraWorld.find_by(server: server, tags: 'now')
          update = pDB[:date] + " +0900"
          diff_time = DateTime.now.to_i - DateTime.parse(update).to_i
          if diff_time <= 3600
            s[server] = "up"
            all+=1
          end
        end
      end
      s['all'] = all
      $cache.set(key, s, 300)
    else
      s = $cache.get(key)
    end
    return JSON.generate(s)
  end

  def ranking
    body = {}
    ['s', 'b', 'v', 'g'].each do |s|
      key = "ranking:"+s
      rank = []
      if $cache.fetch(key).nil?
        if /^(s|b|v|g)$/ =~ s
          index = 0
          tDB = {}

          limit = 5000
          pDB = PapamiraWorld.where(server: s, tags: 'day')
          pDB.order("days desc").limit(1).each do |dbs|
            s = dbs[:server]
            JSON.parse(dbs[:body]).reverse_each do |body|
              body['server'] = s
              index += 1
              tDB[body['name']] = tDB[body['name']] ? tDB[body['name']] + 1 : 1
              break if index >= limit and limit != 0
            end
          end

          ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
          GC.start

          rank = []
          tDB.each do |data|
            name = data[0]
            i = data[1]
            if i.to_i >= 5
              rank << {"name" => name, "count" => i}
            end
          end
          body[s] = rank.sort_by! { |a| a['count'] }.reverse
          $cache.set(key, body[s], 3600)
        end
      else
        body[s] = $cache.get(key)
      end
    end
    return JSON.generate(body)
  end

  def words
    ckey = "tags"
    ref = {}
    if $cache.fetch(ckey).nil?
      ['s', 'b', 'v', 'g'].each do |s|
        ref[s] = []
        if PapamiraSearchWord.where(server: s).count != 0
          pDB = PapamiraSearchWord.find_by(server: s)
          body_in = JSON.parse(pDB[:data])
          body_in.each do |body|
            ref[s].push(body['body']) if body['count'] >= 10
          end
        end
        $cache.set(ckey, ref, 3600)
      end
    else
      ref = $cache.get(ckey)
    end
    return JSON.generate(ref)
  end
  
  def now_shout
    body = ""
    key = 'top_now_shout'
    if $cache.fetch(key).nil?
      if PapamiraWorld.where(server: 'all', tags: 'now').count != 0
        pDB = PapamiraWorld.find_by(server: 'all', tags: 'now')
        data = JSON.parse(pDB[:body])
        body << data['body']
      end
      $cache.set(key, body, 60)
    else
      body = $cache.get(key)
    end
    return JSON.generate(body)
  end

  def random_shout
    body = ""
    pDB = []
    day_max = PapamiraWorld.maximum(:id)
    loop {
      pDB = PapamiraWorld.where(id: rand(1..day_max))
      break if not pDB.empty?
    }
    pDB.each do |dbs|
      bodys = JSON.parse(dbs[:body])
      shout_max = bodys.size
      body = bodys[rand(0..shout_max)]['body']
      break
    end
    JSON.generate(body)
  end

  def shout(params)
    server = CGI.escapeHTML(params[:server].to_s)
    tDB = []

    if /^(s|b|v|g)$/ =~ server
      index = 0
      limit = 100
      ckey = "shout_" + server

      if $cache.fetch(ckey).nil?
        pDB = PapamiraWorld.where(server: server, tags: 'day')
        pDB.order("days desc").limit(1).each do |dbs|
          s = dbs[:server]
          jdata = JSON.parse(dbs[:body])
          page_max = (jdata.size - 1).to_i
          jdata.reverse_each do |body|
            if (DateTime.now.to_i - DateTime.parse(body['date']).to_i).to_i > (86400 * 2)
              body['date'] = body['date'].split(/ /)[0]
            end
            body['page'] = (page_max - index.to_i).to_s
            body['server'] = s
            body['key'] = ''
            body.delete('key')
            body.delete('search_name')
            body.delete('search_body')
            tDB.unshift(body)
            index += 1
            break if index >= limit and limit != 0
          end
          break
        end

        ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
        GC.start

        tDB.sort! { |a, b| b['date'] <=> a['date'] }
        $cache.set(ckey, tDB, 3600)
      else
        tDB = $cache.get(ckey)
      end
    end
    JSON.generate(tDB)
  end

  def shout_days(params)
    tDB = []
    server = CGI.escapeHTML(params[:server].to_s)

    if /^(s|b|v|g)$/ =~ server
      limit = params['limit'].to_i
      if /\d+/ =~ limit.to_s
        if limit > 14
          limit = 14
        elsif limit <= 0
          limit = 1
        end
      else
        limit = 1
      end

      ckey = "shout_days_" + server + "_" + limit.to_s
      if $cache.fetch(ckey).nil?
        if limit != 0
          max_days = Date.parse(DateTime.now.to_s).to_s
          min_days = (Date.parse(DateTime.now.to_s) - limit).to_s
        else
          max_days = Date.parse(DateTime.now.to_s).to_s
          min_days = Date.parse(DateTime.now.to_s).to_s
        end

        date_now = ""
        date_last = ""
        date_feach = ""
        index = 0
        pDB = PapamiraWorld.where(server: server, tags: 'day', days: min_days..max_days)
        pDB.order("days desc").limit(limit).each do |dbs|
          jdata = JSON.parse(dbs[:body])
          page_max = (jdata.size - 1).to_i
          pindex = 0
          jdata.reverse_each do |body|
            if date_last == ""
              date_last = Date.parse(body['date'])
              date_feach = Date.parse(body['date']) - limit
            end
            date_now = Date.parse(body['date'])
            break if date_now <= date_feach

            if (DateTime.now.to_i - DateTime.parse(body['date']).to_i).to_i > (86400 * 2)
              body['date'] = body['date'].split(/ /)[0]
            end

            body['page'] = (page_max - pindex.to_i).to_s
            body['server'] = server
            body['key'] = ''
            body.delete('key')
            body.delete('search_name')
            body.delete('search_body')

            tDB.push(body)
            pindex += 1
          end
          index += 1
          break if index > limit and limit != 0
        end

        ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
        GC.start

        $cache.set(ckey, tDB, 3600)
      else
        tDB = $cache.get(ckey)
      end
    end

    return JSON.generate(tDB)
  end

  def all_shout
    index = {
      's' => 0,
      'b' => 0,
      'v' => 0,
      'g' => 0,
    }
    tDB = []
    limit = 30
    ckey = "all_shout"

    if $cache.fetch(ckey).nil?
      SERVERS.each do |lserver|
        pDB = PapamiraWorld.where(server: lserver, tags: 'day')
        pDB.order("days desc").limit(2).each do |dbs|
          s = dbs[:server]
          jdata = JSON.parse(dbs[:body])
          page_max = (jdata.size - 1).to_i
          jdata.reverse_each do |body|
            if (DateTime.now.to_i - DateTime.parse(body['date']).to_i).to_i > (86400 * 2)
              body['date'] = body['date'].split(/ /)[0]
            end

            body['page'] = (page_max - index[s].to_i).to_s
            body['server'] = s
            body['key'] = ''
            body.delete('key')
            body.delete('search_name')
            body.delete('search_body')

            tDB.unshift(body)
            index[s] += 1
            break if index[s] >= limit and limit != 0
          end
          break
        end
      end

      ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
      GC.start

      tDB.sort! { |a, b| b['date'] <=> a['date'] }
      $cache.set(ckey, tDB, 3600)
    else
      tDB = $cache.get(ckey)
    end
    JSON.generate(tDB)
  end

  def select_day(params)
    day = CGI.escapeHTML(params[:day].to_s)
    server = CGI.escapeHTML(params[:server].to_s)

    ymd = day.scan(%r!^(\d{4})[/|-](\d{2})[/|-](\d{2})$!).join("-")
    body = []

    if (not ymd.nil?)
      if %r!^(\d{4})-(\d{2})-(\d{2})$! =~ ymd
        if not day.nil?
          ckey = "day_" + server + "_" + ymd

          if $cache.fetch(ckey).nil?
            if PapamiraWorld.where(server: server, tags: 'day', days: ymd).count != 0
              pDB = PapamiraWorld.find_by(server: server, tags: 'day', days: ymd)
              jdata = JSON.parse(pDB[:body])
              pindex = 0
              jdata.each do |data|
                timer = (DateTime.now.to_i - DateTime.parse(data['date']).to_i).to_i
                if timer > (86400 * 28)
                  #data['body'] = data['body'][0..4] + "..."
                end
                if timer > (86400 * 14)
                  data['name'] = "ぱぱみら"
                end
                if timer > (86400 * 2)
                  data['date'] = data['date'].split(/ /)[0]
                end
                data['page'] = pindex.to_i.to_s
                data['server'] = server
                data['key'] = ''
                data.delete('key')
                data.delete('search_name')
                data.delete('search_body')
                body.push(data)
                pindex += 1
              end

              ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
              GC.start

              $cache.set(ckey, body, 3600*24)
            end
          else
            body = $cache.get(ckey)
          end
        end
      end
    end
    JSON.generate(body)
  end

  def select_shout(params)
    day = CGI.escapeHTML(params[:day].to_s)
    server = CGI.escapeHTML(params[:server].to_s)

    y, m, d, page = day.scan(%r!^(\d{4})[/|-](\d{2})[/|-](\d{2})[/|-](([0-9]|-|,)+)$!).flatten
    ymd = [y, m, d].join("-")
    body = []

    if (not ymd.nil?)
      if %r!^(\d{4})-(\d{2})-(\d{2})$! =~ ymd
        if not day.nil? and not page.nil?
          ckey = "day_" + server + "_" + ymd + "_" + page.to_s

          if $cache.fetch(ckey).nil?
            if PapamiraWorld.where(server: server, tags: 'day', days: ymd).limit(1).count != 0
              pDB = PapamiraWorld.find_by(server: server, tags: 'day', days: ymd)
              tpage = []
              if /,/ =~ page.to_s
                page.split(/,/).each do |tp|
                  if /-/ =~ tp
                    tpage.push(tp.split(/-/))
                  else
                    tpage.push(tp)
                  end
                end
              else
                if /-/ =~ page
                  tpage.push(page.split(/-/))
                else
                  tpage.push(page)
                end
              end

              pages = tpage.dup
              pages.each do |page|
                if page.size == 2
                  data = JSON.parse(pDB[:body])[page[0].to_i..page[1].to_i]
                  data.each do |data2|
                    if not data2.nil?
                      timer = (DateTime.now.to_i - DateTime.parse(data2['date']).to_i).to_i
                      if timer > (86400 * 28)
                        #data2['body'] = data2['body'][0..4] + "..."
                      end
                      if timer > (86400 * 14)
                        data2['name'] = "ぱぱみら"
                      end
                      if timer > (86400 * 2)
                        data2['date'] = data2['date'].split(/ /)[0]
                      end
                      data2['server'] = server
                      data2['key'] = ''
                      data2.delete('key')
                      data2.delete('search_name')
                      data2.delete('search_body')
                      body.push(data2)
                      $cache.set(ckey, body, 3600*24)
                    end
                  end
                else
                  data = JSON.parse(pDB[:body])[page.to_i]
                  if not data.nil?
                    timer = (DateTime.now.to_i - DateTime.parse(data['date']).to_i).to_i
                    if timer > (86400 * 28)
                      #data['body'] = data['body'][0..4] + "..."
                    end
                    if timer > (86400 * 14)
                      data['name'] = "ぱぱみら"
                    end
                    if timer > (86400 * 2)
                      data['date'] = data['date'].split(/ /)[0]
                    end
                    data['server'] = server
                    data['key'] = ''
                    data.delete('key')
                    data.delete('search_name')
                    data.delete('search_body')
                    body.push(data)
                    $cache.set(ckey, body, 3600*24)
                  end
                end
              end

              ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
              GC.start
            end
          else
            body = $cache.get(ckey)
          end
        end
      end
    end
    JSON.generate(body)
  end

  def autocomplete(params)
    data = params['req']
    res = []

    if not data.nil?
      PapamiraItem.where("index like '%" + data + "%'").each do |text|
        text[:name].split(/,/).each do |item|
          if /^#{data}/ =~ item
            res.push(item)
          end
        end
      end
      
      if res.empty?
        PapamiraItem.where("name like '%" + data + "%'").each do |text|
          text[:name].split(/,/).each do |item|
            if /^#{data}/ =~ item
              res.push(item)
            end
          end
        end
      end

      PapamiraUserWord.where("name like '%" + data + "%'").each do |text|
        if /^#{data}/ =~ text[:name]
          res.push(text[:name])
        end
      end
    end

    JSON.generate(res.uniq)
  end

  def user_search_word(params)
    server = params['server']
    user_word = []
    if PapamiraSearchWord.where(server: server).count != 0
      pDB = PapamiraSearchWord.find_by(server: server)
      body_in = JSON.parse(pDB[:data])
      body_in.sort_by! { |a| a['count'] }.reverse_each do |data|
        if data['count'].to_i >= 20
          user_word.push(data['body'])
        end
      end
    else
      user_word = []
    end
    return JSON.generate(user_word)
  end

  def search_shout(params)
    res = []
    server = params['server']
    tmpkey = params[:word]

    if params[:number].nil?
      number = 100
    else
      if /\d+/ =~ params[:number]
        if params[:number].to_i < 0
          number = 0
        else
          number = params[:number].to_i
        end
        range = 300 if params[:number].to_i > 300
      else
        number = 100
      end
    end

    if params[:range].nil?
      range = 14
    else
      if /\d+/ =~ params[:range]
        if params[:range].to_i < 0
          range = 14
        else
          range = params[:range].to_i
        end
        range = 14 if params[:range].to_i > 14
      else
        range = 14
      end
    end

    if not tmpkey.nil? and not server.nil?
      if not tmpkey.empty? and not server.empty? and /^(s|b|v|g|all)$/ =~ server and tmpkey.empty? == false
        if lock(server)
          res << render_popup
        else
          keys = Regexp.escape(NKF.nkf("-Xwm0Z1", CGI.escapeHTML(params[:word].upcase))).to_s
          ckey = server + keys + number.to_s + range.to_s
          if not keys.empty?
            $search_stack[server] += 1
            if $search_stack[server] > $search_max[server]
              res << render_wait_search
            else
              if $cache.fetch(ckey).nil?
                keys = keys.gsub(/((\\ +)|(　+))+/, " ")
                keys = keys.gsub(/\\\(/, "(")
                keys = keys.gsub(/\\\)/, ")")
                keys = keys.gsub(/\\\|/, "|")
                keys = keys.gsub(/\\ /, " ")
                keys = keys.gsub(/\\-/, "-")
                keys = keys.gsub(/\\\[/, "[")
                keys = keys.gsub(/\\\]/, "]")
                keys = keys.gsub(/\\\./, ".")
                search_reg2 = num_search(keys)
                if search_reg2.empty?
                  search_reg2 = ""
                else
                  keys = num_search_delete(keys)
                end

                if !keys.empty?
                  keyp = keys.split(/\s+/)
                  keyp.delete("")
                  search_reg = ""
                  keyp.each do |t|
                    if /^!/ =~ t
                      search_reg << "^(?!.*#{t.sub(/^!/, "")}).*$"
                    else
                      search_reg << "(?=.*#{t})"
                    end
                  end
                  search_reg << search_reg2

                  case server
                  when 'all'
                    servers_tmp = SERVERS.dup
                    servers_tmp.delete('g')
                  else
                    servers_tmp = [server]
                  end

                  servers_tmp.each do |server_hxh|
                    sql = "server = \'#{server_hxh}\' and tags = \'day\'"

                    index_n = 0
                    index_r = 0
                    break_flg = false
                    pDB = PapamiraWorld.where(sql)
                    pDB.order("days desc").limit(range).each do |dbs|
                      jdata = JSON.parse(dbs[:body])
                      page_max = (jdata.size - 1).to_i
                      pindex  = 0
                      jdata.reverse_each do |data|
                        data['key'] = ''
                        data.delete('key')
                        begin
                          if /#{search_reg}/ =~ NKF.nkf("-Xwm0Z1", (data['name']+data['body']).upcase)
                            data['page'] = (page_max - pindex.to_i).to_s
                            data['server'] = server_hxh
                            if (DateTime.now.to_i - DateTime.parse(data['date']).to_i).to_i > (86400 * 2)
                              data['date'] = data['date'].split(/ /)[0]
                            end
                            res.push(data)
                            index_n += 1
                            if number != 0 and index_n >= number
                              break_flg = true
                              break
                            end
                          end
                          pindex += 1
                        rescue RegexpError
                          break_flg = false
                          break
                        end
                      end
                      index_r += 1
                      if (range != 0 and index_r >= range) or break_flg == true
                        break
                      end
                    end
                    $cache.set(ckey, res, 120)
                    search_word_save(server_hxh, keys)
                  end
                end
              else
                res = $cache.get(ckey)
              end
              ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
              GC.start
            end
            $search_stack[server] -= 1
          end
        end
      end
    end
    if res.class == 'Array'
      JSON.generate(res.uniq)
    else
      res.sort_by! { |a| a['date'] }.reverse!
      JSON.generate(res)
    end
  end

  def search_tags(params)
    server = params[:s].to_s
    res = []
    if lock(server)
      res << render_popup
    else
      key = Regexp.escape(CGI.escapeHTML(params[:tag].toutf8)).to_s
      case key
      when "買"
        key = ["買", "露店"]
        key2 = "(買|露店)"
      when "売"
        key = ["売", "露店"]
        key2 = "(売|露店)"
      when "ギルド"
        key = ["ギルド", "攻城", "ステG", "GVG"]
        key2 = "(?=.*(ギルド|攻城|ステG|GVG))^(?!.*(ギルドクエ|ギルドデイリ)).*$"
      when "秘密"
        key = ["秘密", "PT"]
        key2 = "(秘密|PT)"
      when "PT"
        key = ["", "PT", "ハント"]
        key2 = "(?=.*(PT))^(?!.*(PTハンティング|Gクエ)).*$"
      when "かけら"
        key = ["かけら", "欠片", "カケラ", "飛ばし", "代行", "出し"]
        key2 = "(?=.*(かけら|欠片|カケラ))(?=.*(飛ばし|代行|出し))^(?!.*(黒き炎|魔界|試練|神秘)).*$"
      when "各種代行"
        key = ["代行"]
        key2 = "(?=.*代行)^(?!.*(欠片|かけら|カケラ)).*$"
      when "GEM"
        key = ["GEM"]
        key2 = "GEM"
      when "クエ"
        key = ["メインクエ", "MQ"]
        key2 = "(?=.*(メインクエ|MQ))"
      when "鏡"
        key = ["鏡"]
        key2 = "(?=.*(鏡))^(?!.*(神秘|魔界)).*$"
      when "テイム"
        key = ["テイム"]
        key2 = "テイム"
      when "ツボ"
        key = ["壷"]
        key2 = "(壷|つぼ|ツボ)"
      when "インク"
        key = ["インク"]
        key2 = "(?=.*(インク))^(?!.*(メインクエ)).*$"
      when "クレスト"
        key = ["クレスト"]
        key2 = "(?=.*(クレスト))"
      when "その他"
        key = ["その他"]
        key2 = "^(?!.*(よろ|締め切り|インク|露店|＠|ラット|エンチャ|出|古代王|代行|G|BF|リスト|発|レイド|待機|放置|〆|買|売|求|鏡|秘密|募集|神秘|魔界|MQ|GEM|欠片|かけら|カケラ|黒き炎|魔界|試練|神秘|PT|ハンティング|ギルド|クエ|デイリ)).*$"
      else
        key = []
        key2 = ""
      end

      if not key2.empty?
        ckey = server + key.join
        $search_stack[server] += 1
        if $search_stack[server] > $search_max[server]
          res << render_wait_search
        else
          if $cache.fetch(ckey).nil?
            day = 0
            case server
            when 'all'
              sql = "tags = \'day\'"
            when 's', 'b', 'v', 'g'
              sql = "server = \'#{server}\' and tags = \'day\'"
            else
              sql = ""
            end
            pDB = PapamiraWorld.where(sql)
            pDB.order("days desc").limit(14).each do |dbs|
              jdata = JSON.parse(dbs[:body])
              page_max = (jdata.size - 1).to_i
              pindex  = 0
              jdata.reverse_each do |data|
                if /#{key2}/ =~ NKF.nkf("-Xwm0Z1", data['body'].upcase)
                  rserver = ''
                  API_KEY.each do |server_name, api_key|
                    if api_key == data['key']
                      rserver = server_name
                      break
                    end
                  end
                  data['page'] = (page_max - pindex.to_i).to_s
                  data['server'] = rserver
                  data['key'] = ''
                  data.delete('key')

                  if (DateTime.now.to_i - DateTime.parse(data['date']).to_i).to_i > (86400 * 2)
                    data['date'] = data['date'].split(/ /)[0]
                  end

                  res << data
                end
                pindex += 1
              end
              day += 1
              break if day >= 14
            end
            $cache.set(ckey, res, 300)
          else
            res = $cache.get(ckey)
          end

          ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
          GC.start
        end

        $search_stack[server] -= 1
      end
    end
    res.sort_by! { |a| a['date'] }.reverse!
    JSON.generate(res)
  end

  def search_name(params)
    res = []
    server = params['server']
    tmpkey = params[:word]
    if not tmpkey.nil? and not server.nil?
      if not tmpkey.empty? and not server.empty? and /^(s|b|v|g)$/ =~ server and tmpkey.empty? == false
        if lock(server)
          res << render_popup
        else
          keys = Regexp.escape(CGI.escapeHTML(params[:word].toutf8)).to_s
          ckey = server + keys
          if not keys.empty?
            $search_stack[server] += 1
            if $search_stack[server] > $search_max[server]
              res << render_wait_search
            else
              if $cache.fetch(ckey).nil?
                sql = ""
                keyp = keys.gsub(/((\\ +)|(　+))+/, " ").split(/\s+/)
                keyp.each do |key|
                  if sql.empty?
                    sql = "server = \'#{server}\' and tags = \'day\' and ( body like '%" + key + "%'"
                  else
                    sql << " and body like '%" + key + "%'"
                  end
                end
                sql << " )"

                pDB = PapamiraWorld.where(sql)
                pDB.order("days desc").each do |dbs|
                  JSON.parse(dbs[:body]).reverse_each do |data|
                    keyf = false
                    keyp.each do |key|
                      if /#{key}/ =~ data['name'].to_s
                        keyf = true
                      else
                        keyf = false
                        break
                      end
                    end
                    if keyf
                      data['key'] = ''
                      data.delete('key')
                      res << data['name']
                    end
                  end
                end
                res.uniq!
                $cache.set(ckey, res, 120)
              else
                res = $cache.get(ckey)
              end
              ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
              GC.start
            end
            $search_stack[server] -= 1
          end
        end
      end
    end
    JSON.generate(res.uniq)
  end

  def time_of_days(server, limit)
    server ='all' if server.nil?
    limit = 1 if limit.nil?
    if /^\d+$/ =~ limit.to_s
      limit = limit.to_i
    else
      limit = 1
    end

    if not server.nil? and not limit.nil?
      if server.empty? or server == 'all'
        index = {
          's' => 0,
          'b' => 0,
          'v' => 0,
          'g' => 0,
        }
        tDB = {
          's' => [],
          'b' => [],
          'v' => [],
          'g' => [],
        }
        SERVERS.each do |lserver|
          pDB = PapamiraWorld.where(server: lserver, tags: 'day')
          pDB.order("days desc").limit(limit).each do |dbs|
            s = dbs[:server]
            JSON.parse(dbs[:body]).each do |body|
              body.delete('key')
              body.delete('stat')
              body.delete('search_name')
              body.delete('search_body')
              body.delete('name')
              body.delete('body')
              tDB[dbs[:server]].unshift(body)
            end
            index[s] += 1
            break if index[s] >= limit and limit != 0
          end
        end

        ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
        GC.start

        return tDB
      else
        if limit != 0
          max_days = Date.parse(DateTime.now.to_s).to_s
          min_days = (Date.parse(DateTime.now.to_s) - limit).to_s
        else
          max_days = Date.parse(DateTime.now.to_s).to_s
          min_days = Date.parse(DateTime.now.to_s).to_s
        end

        index = 0
        tDB = []
        pDB = PapamiraWorld.where(server: server, tags: 'day', days: min_days..max_days)
        pDB.order("days desc").limit(limit).reverse_each do |dbs|
          JSON.parse(dbs[:body]).each do |body|
            body.delete('key')
            body.delete('stat')
            body.delete('search_name')
            body.delete('search_body')
            body.delete('name')
            body.delete('body')
            tDB.unshift(body)
          end
          index += 1
          break if index > limit and limit != 0
        end

        ObjectSpace.each_object(ActiveRecord::Relation).each(&:reset)
        GC.start

        return tDB
      end
    else
      return []
    end
  end

  def graph_select_day(params)
    days = params[:days]

    day_data = {
      's' => [],
      'b' => [],
      'v' => [],
      'g' => [],
    }
    if not days.nil?
      ymd = days.gsub(/\//, "-")
      if %r!^(\d{4})-(\d{2})-(\d{2})$! =~ ymd
        if PapamiraWorld.where(tags: 'day', days: ymd).count != 0
          pDB = PapamiraWorld.where(tags: 'day', days: ymd)
          pDB.each do |db|
            if not db[:server].empty?
              day_data[db[:server]] = JSON.parse(db[:body])
            end
          end
        end
      end
    end

    date_now = ""
    date_last = ""
    date_feach = ""

    title_server = "3"
    range = days.to_s

    active_hash = {
      's' => {},
      'b' => {},
      'v' => {},
      'g' => {},
    }
    24.times do |t|
      active_hash['s'][t] = 0
      active_hash['b'][t] = 0
      active_hash['v'][t] = 0
      active_hash['g'][t] = 0
    end

    day_data.each do |sname, data|
      data.each do |text|
        date = text['date']

        date_now = Date.parse(date)
        if date_last == ""
          date_last = date_now.dup
          date_feach = date_now - days.to_i
        end

        break if date_now < date_feach

        hh = ParseDate::parsedate(date)[3]
        active_hash[sname][hh.to_i] += 1
      end
    end

    body = graph_js(active_hash, "時", 'day')

    res = {
      "body" => body,
      "server" => title_server,
      "range" => range,
    }
    JSON.generate(res)
  end

  def graph_server(params)
    s = params[:server].to_s
    title_server = s.upcase

    key = "info:"+"#{s}:"+"alldays"+":v2"
    if $cache.fetch(key).nil?
      active_hash = {}
      24.times do |t|
        active_hash[t] = 0
      end

      ldate = ""
      fdate = ""
      self.time_of_days(s, 90).each do |text|
        date = text['date']
        if ldate.empty?
          ldate = date
          fdate = date
        else
          if ldate > date
            ldate = date
          end
          if fdate < date
            fdate = date
          end
        end

        hh = ParseDate::parsedate(date)[3]
        active_hash[hh] += 1
      end

      date_area = ldate.split(/ /)[0].to_s + "-" + fdate.split(/ /)[0].to_s
      if date_area != '-'
        range = "[#{date_area}]"
      else
        range = ""
      end

      active_hash_v2 = {
        "data" => active_hash,
        "range" => range,
      }
      $cache.set(key, active_hash_v2, 3600*24)
    else
      active_hash = $cache.get(key)['data']
      range = $cache.get(key)['range']
    end

    body = graph_js(active_hash, "時", 'server')

    res = {
      "body" => body,
      "server" => title_server,
      "range" => range,
    }
    JSON.generate(res)
  end

  def graph_days(params)
    days = params[:day]
    days = "1" if days.nil?
    days = "1" if days.empty?
    days = "1" if /^\d+$/ !~ days.to_s
    days = "30" if days.to_i > 30
    days = days.to_i

    date_now = ""
    date_last = ""
    date_feach = ""

    title_server = "3"
    range = days.to_s

    key = "all:"+(days+1).to_s+":"+"days"
    if $cache.fetch(key).nil?
      active_hash = {
        's' => {},
        'b' => {},
        'v' => {}, 
        'g' => {}, 
      }
      24.times do |t|
        active_hash['s'][t] = 0
        active_hash['b'][t] = 0
        active_hash['v'][t] = 0
        active_hash['g'][t] = 0
      end

      self.time_of_days("all", days+1).each do |sname, data|
        data.each do |text|
          date = text['date']

          date_now = Date.parse(date)
          if date_last == ""
            date_last = date_now.dup
            date_feach = date_now - days.to_i
          end

          break if date_now < date_feach

          hh = ParseDate::parsedate(date)[3]
          active_hash[sname][hh.to_i] += 1
        end
      end
      if days <= 1
        $cache.set(key, active_hash, 1800)
      else
        $cache.set(key, active_hash, 3600*24)
      end
    else
      active_hash = $cache.get(key)
    end

    body = graph_js(active_hash, "時", 'day')

    res = {
      "body" => body,
      "server" => title_server,
      "range" => range,
    }
    JSON.generate(res)
  end

  def graph_wdays(params)
    days = params[:day]
    days = "7" if days.nil?
    days = "7" if days.empty?
    days = "7" if /^\d+$/ !~ days.to_s
    days = "28" if days.to_i > 28
    days = days.to_i
    date_now = ""
    date_last = ""
    date_feach = ""

    title_server = "3"
    range = days.to_s

    key = "all:"+days.to_s+":"+"days"
    if $cache.fetch(key).nil?
      active_hash = {
        's' => {},
        'b' => {},
        'v' => {}, 
        'g' => {}, 
      }
      7.times do |t|
        active_hash['s'][t] = 0
        active_hash['b'][t] = 0
        active_hash['v'][t] = 0
        active_hash['g'][t] = 0
      end

      self.time_of_days("all", days).each do |sname, data|
        data.each do |text|
          date = text['date']

          date_now = Date.parse(date)
          if date_last == ""
            date_last = date_now.dup
            date_feach = date_now - days.to_i
          end

          break if date_now < date_feach

          hh = ParseDate::parsedate(date)[3]
          this_wday = date_now.wday
          active_hash[sname][this_wday] += 1
        end
      end
      if days <= 1
        $cache.set(key, active_hash, 1800)
      else
        $cache.set(key, active_hash, 3600*24)
      end
    else
      active_hash = $cache.get(key)
    end

    body = graph_js(active_hash, "曜日", 'wday')

    res = {
      "body" => body,
      "server" => title_server,
      "range" => range,
    }
    JSON.generate(res)
  end

  def graph_js(active_hash, unit, type)
    case type
    when 'day'
      return graph_d_js(active_hash, unit)
    when 'server'
      return graph_s_js(active_hash, unit)
    when 'wday'
      return graph_w_js(active_hash, unit)
    end
  end

  def graph_s_js(active_hash, unit)
    all = []

    active_hash.each do |time, val|
      omoshi = graph_omoshi(time)
      all.push([time, val, omoshi])
    end

    body = []
    all.sort {|a, b| a[2] <=> b[2] }.each do |t, val, omoshi|
      body.push( { "label" => t.to_s+unit, "y" => val.to_i, } )
    end
    return body
  end

  def graph_d_js(active_hash, unit)
    all = {
      's' => [],
      'b' => [],
      'v' => [],
      'g' => [],
    }

    active_hash.each do |name, vals|
      vals.each do |time, val|
        omoshi = graph_omoshi(time)
        all[name].push([time, val, omoshi])
      end
    end

    body = {}
    all.each do |name, vals|
      body[name] = []
      vals.sort {|a, b| a[2] <=> b[2] }.each do |t, val, omoshi|
        body[name].push( { "label" => t.to_s+unit, "y" => val.to_i, } )
      end
    end
    return body
  end

  def graph_w_js(active_hash, unit)
    dayweek = ["日", "月", "火", "水", "木", "金", "土"]
    all = {
      's' => [],
      'b' => [],
      'v' => [],
      'g' => [],
    }

    active_hash.each do |name, vals|
      vals.each do |time, val|
        omoshi = graph_omoshi_wdays(time)
        all[name].push([time, val, omoshi])
      end
    end

    body = {}
    all.each do |name, vals|
      body[name] = []
      vals.sort {|a, b| a[2] <=> b[2] }.each do |t, val, omoshi|
        body[name].push( { "label" => dayweek[t.to_i]+unit, "y" => val.to_i, } )
      end
    end

    return body
  end

  def graph_omoshi(str)
    a = {}
    s = 18
    24.times do |i|
      s = 0 if s > 23
      a[i] = s
      s+=1
    end
    return a[str]
  end

  def graph_omoshi_wdays(str)
    a = {}
    s = 4
    7.times do |i|
      s = 0 if s > 6
      a[i] = s
      s+=1
    end
    return a[str]
  end

  def _1day_shout(params)
    res = []
    server = params['server']
    if not server.nil?
      if not server.empty? and /^(s|b|v|g)$/ =~ server
        day_last = PapamiraWorld.where(server: server).maximum(:id)
        pDB = PapamiraWorld.where(id: day_last, )
        pDB.each do |dbs|
          JSON.parse(dbs[:body]).reverse_each do |body|
            body.delete('key')
            body.delete('stat')
            res << body
          end
        end
      else
        res = "error Server Name."
      end
    else
      res = "error Server Name no set."
    end
    JSON.generate(res)
  end

  def all_web_connect
    return JSON.generate($web_clients.size)
  end

  def web_connect(params)
    server = params['server']
    if not server.nil?
      if not server.empty? and /^(s|b|v|g|all)$/ =~ server
        int = 0
        $web_clients.each do |w|
          if /^\/#{server}\/(stream|ppap)$/ =~ w.env["REQUEST_PATH"]
            int += 1
          end
        end
        res = int.to_s
      else
        res = "error Server Name."
      end
    else
      res = "error Server Name no set."
    end
    return JSON.generate(res)
  end

  def web_connects
    group = {}
    ['s', 'b', 'v', 'g', 'all', 'home'].each do |s|
      group[s] = 0
    end

    int = 0
    $web_clients.each do |w|
      case w.env["REQUEST_PATH"]
      when /^\/s\/(stream|ppap)$/
        group['s'] += 1
      when /^\/b\/(stream|ppap)$/
        group['b'] += 1
      when /^\/v\/(stream|ppap)$/
        group['v'] += 1
      when /^\/g\/(stream|ppap)$/
        group['g'] += 1
      when /^\/all\/(stream|ppap)$/
        group['all'] += 1
      else
        group['home'] += 1
      end
    end
    return JSON.generate(group)
  end

  def server_alive(params)
    server = params['server']
    if not server.nil?
      if not server.empty? and /^(s|b|v|g|all)$/ =~ server
        s = {}
        key = "server_alive:"+server
        if $cache.fetch(key).nil?
          ["s", "b", "v", "g"].each do |server|
            s[server] = "down"
            if PapamiraWorld.where(server: server, tags: 'now').count != 0
              pDB = PapamiraWorld.find_by(server: server, tags: 'now')
              update = pDB[:date] + " +0900"
              diff_time = DateTime.now.to_i - DateTime.parse(update).to_i
              if diff_time <= 3600
                s[server] = "up"
              end
            end
          end

          case server
          when 's'
            res = s['s']
          when 'b'
            res = s['b']
          when 'v'
            res = s['v']
          when 'g'
            res = s['g']
          when 'all'
            res = s
          else
            res = "error Server Name."
          end
          $cache.set(key, res, 300)
        else
          res = $cache.get(key)
        end
      else
        res = "error Server Name."
      end
    else
      res = "error Server Name no set."
    end
    return JSON.generate(res)
  end

  def server_hitpoint
    key = 'server_hitpoint'
    if $cache.fetch(key).nil?
      hp = 0
      con = ActiveRecord::Base.connection
      con.select_all('SELECT T2.relname , T2.reltuples FROM pg_stat_user_tables AS T1 INNER JOIN pg_class AS T2 ON T1.relname = T2.relname ORDER BY T2.relname;').to_hash.each do |table_data|
        hp += table_data['reltuples'].to_i
      end
      $cache.set(key, hp, 86400)
    else
      hp = $cache.get(key)
    end
    return JSON.generate((SERVER_HP - hp.to_i).to_s)
  end

  def voice_dic
    key = "voice_dic_v1"
    if $cache.fetch(key).nil?
      res = JSON.parse(File.open("data/web_speech.dic").read)
      $cache.set(key, res, 300)
    else
      res = $cache.get(key)
    end
    return JSON.generate(res)
  end
end
