function init() {
  var ws = null;
  open();
}

function open() {
  var proto  = location.protocol === 'https:' ? 'wss' : 'ws'
  var ws     = new WebSocket(proto + '://' + window.location.host + window.location.pathname);

  ws.onopen  = function() {
  };

  ws.onclose = function() {
    ws = null;
    setTimeout("open()", 5000);
  };

  ws.onmessage = function(m) { 
    template = 'BODY';
    show_json(m.data, template);
  };
};

function show_json(msg, template){
  var j = $.parseJSON(msg);

  template = template.replace(/BODY/, j.body);

  $("#real_shout").html(template);
  $("#real_shout").hide().fadeIn(1000);
  $("#real_shout").slideDown("slow");
};

function close() {
  ws = null;
};

window.onload = function(){
  init();
};
